function CDX = set_zero_RP_pJTD(CDX)
% --------------------------------------------------------------------------------------------------
% Set the pure JTD risk premium equal to zero.
% --------------------------------------------------------------------------------------------------
% CDX                       ... credit index structure (see 'all_steps_in_a_row.m')
% --------------------------------------------------------------------------------------------------
% sample call: set_zero_RP_pJTD(cdx_tv_monthly10)
% --------------------------------------------------------------------------------------------------

for i=1:length(CDX.portfolio)
    cds = CDX.portfolio(i);
    
    % (i)  b_it_Q  <-  b_it_P
    if (~isempty(cds.bi_P))
        cds.bi = cds.bi_P;
    end

    % (ii) a_it_Q  <-  a_it_Q - a_it_P * (b_Q/b_P - 1)     
    if isempty(cds.bi_P)
        % Do nothing (for now) if no physical default dynamics available
    else
        cds.ai = cds.ai - cds.ai_P .* (cds.bi ./ cds.bi_P - 1);
        if (min(cds.ai) < 0)
            warning('Negative factor loading');
        end
        cds.ai = max(0, cds.ai);
    end
    CDX.portfolio(i) = cds;
end